<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UserController;


Route::get('/', fn() => responder()->message('Welcome to Solar application!')->send());

Route::prefix('admin/users')
    ->controller(UserController::class)
    ->group(function () {
        Route::get('dashboard', 'dashboard')
            ->name('admin.dashboard');

        Route::get('factory-owners', 'getFactoryOwners')
            ->name('users.factory-owner.index');

        Route::get('investors', 'getInvestors')
            ->name('users.investor.index');

        Route::post('logout', 'logout')->name('logout');
    });

