@extends('Admin.Layout.main')
@section('title', 'لیست سرمایه گذاران')
@section('header', 'لیست سرمایه گذاران')
@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box table-responsive">

                <h4 class="header-title m-t-0 m-b-30 inb">
                    <i class="fa fa-money i-fix"></i>
                    تعداد کل سرمایه گذاران:
                    {{ $investors->count() }}
                    نفر
                </h4>

                @if($investors->count())
                    <!-- Table Start !-->
                    <table id="datatable" class="table table-striped table-bordered">
                        <thead>
                        <tr>
                            <th>ردیف</th>
                            <th>نام و نام خانوادگی</th>
                            <th>شماره تلفن</th>
                            <th>ایمیل</th>
                            <th>نوع طرح</th>
                            <th>میزان سرمایه گذاری (ریال)</th>
                            <th>توان تولیدی</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($investors as $row => $investor)
                            @php $specification = $investor->specification;@endphp
                            <tr>
                                <td><?= $row + 1 ?></td>
                                <td class="categoryName">{{ $investor->full_name }}</td>
                                <td>{{ $investor->phone }}</td>
                                <td>{{ $investor->email ?? "-"  }}</td>
                                <td>{{ "بر اساس " . $investor->plan->toPersianString()  }}</td>
                                <td>{{ $specification->investment ? number_format($specification->investment) : "-" }}</td>
                                <td class="txt-ltr">{{ $specification->production ? $specification->production .  "MW"  : "-"}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <!-- Table End !-->
                    {{ $investors->links() }}
                @else
                    {!! emptyState('هیچ سرمایه گذاری توی سیستم ثبت نشده!') !!}
                @endif
            </div>
        </div>
    </div>

@endsection
