@extends('Admin.Layout.main')
@section('title', 'لیست کارخانه داران')
@section('header', 'لیست کارخانه داران')
@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card-box table-responsive">

                <h4 class="header-title m-t-0 m-b-30 inb">
                    <i class="fa fa-home i-fix"></i>
                    تعداد کل کارخانه داران:
                    {{ $factoryOwners->count() }}
                    نفر
                </h4>

                @if($factoryOwners->count())
                    <!-- Table Start !-->
                    <table id="datatable" class="table table-striped table-bordered">
                        <thead>
                        <tr>
                            <th>ردیف</th>
                            <th>نام و نام خانوادگی</th>
                            <th>شماره تلفن</th>
                            <th>ایمیل</th>
                            <th>نام شرکت</th>
                            <th>آدرس شرکت</th>
                            <th>نوع طرح</th>
                            <th>دیماند</th>
                            <th>تعداد شیفت کاری</th>
                            <th>اجاره ماهیانه زمین (ریال)</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($factoryOwners as $row => $factoryOwner)
                            @php $specification = $factoryOwner->specification;@endphp

                            <tr>
                                <td><?= $row + 1 ?></td>
                                <td class="categoryName">{{ $factoryOwner->full_name }}</td>
                                <td>{{ $factoryOwner->phone }}</td>
                                <td>{{ $factoryOwner->email ?? "-"  }}</td>
                                <td>{{ $factoryOwner->company_name ?? "-" }}</td>
                                <td>{{ $factoryOwner->company_address?? "-" }}</td>
                                <td>
                                    بر اساس
                                    {{ $factoryOwner->plan->toPersianString() }}
                                </td>
                                <td>{{ $specification->demanded }}</td>
                                <td>{{ $specification->work_shifts }}</td>
                                <td>{{ $specification->rent ? number_format($specification->rent) : '-' }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <!-- Table End !-->
                    {{ $factoryOwners->links() }}
                @else
                    {!! emptyState('هیچ کارخونه داری توی سیستم ثبت نشده') !!}
                @endif
            </div>
        </div>
    </div>

@endsection
