<!DOCTYPE html>
<html lang="en" dir="rtl">

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc.">
    <meta name="author" content="Coderthemes">

    <link rel="icon" href="/admin/images/rayapro.ico">

    <title>@yield('title')</title>

    <!--Morris Chart CSS -->
    <link rel="stylesheet" href="{{ asset('admin/plugins/morris/morris.css') }}">

    <!-- App css -->
    <link href="{{ asset('admin/css/bootstrap-rtl.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/core.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/components.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/icons.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/pages.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/menu.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/responsive.css') }}" rel="stylesheet" type="text/css"/>

    <!-- Pretty CheckBox !-->
    <link href="{{ asset('admin/css/checkbox.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ asset('admin/css/materialdesignicons.min.css') }}" rel="stylesheet" type="text/css"/>

    <link href="{{ asset('admin/css/developer.css') }}" rel="stylesheet" type="text/css"/>
    <script src="{{ asset('admin/js/jquery.min.js') }}"></script>
    <script src="{{ asset('admin/js/modernizr.min.js') }} "></script>
    <script src="{{ asset('admin/js/sweetalert.js') }} "></script>
    <script src="{{ asset('admin/js/customJS/developer.js') }} "></script>
    @stack('css')
    @stack('js')
    <script>
        $(window).load(function(){
        $('.preloader').fadeOut('slow');
        });


    </script>

</head>


<body class="fixed-left no_print_links">

{{-- <div class="preloader"></div> --}}
<!-- Begin page -->
<div id="wrapper">

    <!-- Top Bar Start -->
    <div class="topbar">

        <!-- LOGO -->
        <div class="topbar-left">
            <a href="{{ route('admin.dashboard') }}" class="logo">
                <span>پنل<span> مدیریت</span></span>
                <i class="zmdi zmdi-layers"></i></a>
        </div>

        <!-- Button mobile view to collapse sidebar menu -->
        <div class="navbar navbar-default" role="navigation">
            <div class="container">

                <!-- Page title -->
                <ul class="nav navbar-nav navbar-left">
                    <li>
                        <button class="button-menu-mobile open-left">
                            <i class="zmdi zmdi-menu"></i>
                        </button>
                    </li>
                    <li>
                        <h4 class="page-title">@yield('header')</h4>
                    </li>
                </ul>
            </div><!-- end container -->
        </div><!-- end navbar -->
    </div>
    <!-- Top Bar End -->
