<?php

use App\Models\Specification;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('specifications', function (Blueprint $table) {
            $table->id();
            $table->integer(Specification::COLUMN_USER_ID);
            $table->integer(Specification::COLUMN_INVESTMENT)->nullable();
            $table->integer(Specification::COLUMN_PRODUCTION)->nullable();
            $table->integer(Specification::COLUMN_DEMAND)->nullable();
            $table->integer(Specification::COLUMN_WORK_SHIFTS)->nullable();
            $table->integer(Specification::COLUMN_CONSUMPTION)->nullable();
            $table->integer(Specification::COLUMN_REGION)->nullable();
            $table->integer(Specification::COLUMN_RENT)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('specifications');
    }
};
