<?php

use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string(User::COLUMN_FULL_NAME);
            $table->string(User::COLUMN_PHONE);
            $table->string(User::COLUMN_EMAIL)->nullable();
            $table->string(User::COLUMN_COMPANY_NAME)->nullable();
            $table->string(User::COLUMN_COMPANY_ADDRESS)->nullable();
            $table->unsignedInteger(User::COLUMN_TYPE);
            $table->unsignedInteger(User::COLUMN_PLAN);
            $table->timestamps();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('sessions');
    }
};
