<?php

namespace App\Models;

use App\Enums\UserTypeEnum;
use App\Enums\PlanTypeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class User extends Model
{
    use HasFactory;

    const COLUMN_FULL_NAME = 'full_name';
    const COLUMN_PHONE = 'phone';
    const COLUMN_EMAIL = 'email';
    const COLUMN_COMPANY_NAME = 'company_name';
    const COLUMN_COMPANY_ADDRESS = 'company_address';
    const COLUMN_TYPE = 'type';
    const COLUMN_PLAN = 'plan';

    protected function casts(): array
    {
        return [
            self::COLUMN_TYPE => UserTypeEnum::class,
            self::COLUMN_PLAN => PlanTypeEnum::class
        ];
    }

    public function scopeInvestor(Builder $query)
    {
        $query->where(self::COLUMN_TYPE, UserTypeEnum::INVESTOR);
    }

    public function scopeFactoryOwner(Builder $query)
    {
        $query->where(self::COLUMN_TYPE, UserTypeEnum::FACTORY_OWNER);
    }

    public function specification(): HasOne
    {
        return $this->hasOne(Specification::class);
    }

    public function factor(): HasMany
    {
        return $this->hasMany(Factor::class);
    }
}
