<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreInformationRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            // User Information
            'user_information' => ['required', 'array'],
            'user_information.full_name' => ['required', 'string', 'min:3', 'max:120'],
            'user_information.phone' => [
                'required',
                'string',
                'min:11',
                'max:11'
            ],
            'user_information.email' => ['nullable', 'email'],
            'user_information.type' => ['required', Rule::in(['investor', 'factory'])],
            'user_information.company' => ['required', 'array'],
            'user_information.company.name' => ['nullable', 'string'],
            'user_information.company.address' => ['nullable', 'string'],

            'plan' => [
                'required',
                Rule::in([
                    'investment',
                    'production',
                    'demanded',
                    'consumption'
                ])
            ],

            // Specifications
            'specifications' => ['required', 'array'],
            'specifications.investment' => ['nullable', 'numeric'],
            'specifications.production' => ['nullable', 'numeric'],
            'specifications.work_shifts' => ['nullable', 'numeric'],
            'specifications.demanded' => ['nullable', 'numeric'],
            'specifications.consumption' => ['nullable', 'numeric'],
            'specifications.rent' => ['nullable', 'numeric'],

            // Factors
            'factors' => ['required', 'array'],
            'factors.*.id' => ['required', 'string'],
            'factors.*.default_value' => ['required', 'numeric'],
            'factors.*.value' => ['required', 'numeric'],
        ];
    }
}
