<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\UserRepository;

class UserController extends Controller
{

    public function __construct(public UserRepository $userRepository)
    {
    }

    public function dashboard()
    {
        $statistics = $this->userRepository->getStatistics();

        return view('Admin.dashboard', compact('statistics'));
    }

    public function getFactoryOwners()
    {
        $factoryOwners = $this->userRepository->getFactoryOwners();

        return view('Admin.User.factory-owners', compact('factoryOwners'));
    }

    public function getInvestors()
    {
        $investors = $this->userRepository->getInvestors();

        return view('Admin.User.investors', compact('investors'));
    }

}
