<?php

namespace App\Enums;

enum UserTypeEnum: int
{
    case INVESTOR = 1;

    case FACTORY_OWNER = 2;

    public static function tryFromString($string): UserTypeEnum
    {
        return match ($string) {
            'investor' => self::INVESTOR,
            'factory' => self::FACTORY_OWNER
        };
    }
}
