<?php

namespace App\Enums;

enum PlanTypeEnum: int
{
    case INVESTOR_INVESTMENT = 1;
    case INVESTOR_PRODUCTION = 2;
    case FACTORY_DEMANDED = 3;
    case FACTORY_CONSUMPTION = 4;

    public static function tryFromString($string): PlanTypeEnum
    {
        return match ($string) {
            'investment' => self::INVESTOR_INVESTMENT,
            'production' => self::INVESTOR_PRODUCTION,
            'demanded' => self::FACTORY_DEMANDED,
            'consumption' => self::FACTORY_CONSUMPTION
        };
    }

    public function toPersianString(): string
    {
        return match($this){
            self::INVESTOR_INVESTMENT => "میزان سرمایه گذاری",
            self::INVESTOR_PRODUCTION => "توان تولیدی",
            self::FACTORY_DEMANDED => "دیماند",
            self::FACTORY_CONSUMPTION => "توان مصرفی",
        };
    }
}
