<?php

namespace App\DataTransferObjects\Website;

use App\Enums\PlanTypeEnum;
use Illuminate\Http\Request;
use App\Core\Contracts\DataTransferObject\RequestDataTransferObject;

class StoreInformationDTO implements RequestDataTransferObject
{
    public array $userInformation;

    public PlanTypeEnum $planType;

    public array $specifications;

    public array $factors;

    public function getDataFromRequest(Request $request): void
    {
        $this->userInformation = $request->post('user_information');
        $this->planType = PlanTypeEnum::tryFromString($request->post('plan'));
        $this->specifications = $request->post('specifications');
        $this->factors = $request->post('factors');
    }
}
